<?php
// reset_admin.php - Rode uma vez para resetar senha do admin para "admin"
// Depois apague este arquivo por segurança.

define('USERS_FILE', __DIR__ . '/users.json');

if (!is_writable(__DIR__)) {
    http_response_code(500);
    echo "Erro: pasta não gravável pelo PHP. Verifique permissões.";
    exit;
}

if (!file_exists(USERS_FILE)) {
    file_put_contents(USERS_FILE, json_encode([], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$users = json_decode(file_get_contents(USERS_FILE), true);
if (!is_array($users)) $users = [];

$found = false;
for ($i = 0; $i < count($users); $i++) {
    if (isset($users[$i]['username']) && strtolower($users[$i]['username']) === 'admin') {
        $users[$i]['password_hash'] = password_hash('admin', PASSWORD_DEFAULT);
        $users[$i]['role'] = 'master';
        $users[$i]['active'] = true;
        $users[$i]['expires_at'] = null;
        $found = true;
        break;
    }
}

if (!$found) {
    // cria um admin novo
    $users[] = [
        'id' => 'admin_' . time(),
        'username' => 'admin',
        'email' => 'admin@local',
        'password_hash' => password_hash('admin', PASSWORD_DEFAULT),
        'role' => 'master',
        'master_id' => null,
        'expires_at' => null,
        'active' => true,
        'created_at' => date(DATE_ATOM)
    ];
}

if (file_put_contents(USERS_FILE, json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) === false) {
    http_response_code(500);
    echo "Erro ao salvar users.json. Verifique permissões de arquivo.";
    exit;
}

echo "OK: senha do admin redefinida para 'admin'. APAGUE este arquivo do servidor por segurança.";